disp('Pick data directory for processing')
disp('')
CWD=pwd;
Data_Dir=uigetdir;
%cd(Data_Dir)
datafiles=uipickfiles('filterspec',[Data_Dir,'/User*']);
cd(CWD)
numfiles=length(datafiles);

Max_Velocity=19.4;
SNR_cutoff=1.005;

for j=1:numfiles
  %FILENAME=fullfile(Data_Dir,datafiles(j));
  fid=fopen(char(datafiles(j)));
  temp=read_Proc_profiles(fid,0.0);
  fclose(fid)
  tt=datevec(temp.start_time);
  temp.timestamp=datenum([tt(1) tt(2) tt(3) tt(4) tt(5) tt(6)]);

  temp.name=datafiles(j);
  temp.datet=datestr(temp.start_time,'mm/dd/yyyy');
  lidar=temp;
  [na,nr]=size(lidar.SNR);
  meanSNR=mean(mean(lidar.SNR(:,nr-50:nr)));
%
% --- Filter --------------------------------------------------------
%disp('--------------------------------------------------------------------------------')
%Max_Velocity=25.;
%SNR_cutoff=1.015;
  %temp=File_Cleaner_V2(lidar,Max_Velocity,SNR_cutoff);
  %disp('Filtering Complete.')
  vad=temp;
  clear temp

  prof=vvp_regression(vad);
  ind=find(prof.nind<3);
  prof.beta(ind)=NaN;
  prof.turb(ind)=NaN;
  prof.vels(ind,:)=NaN;
  prof.theta(ind)=NaN;
  prof.u(ind)=NaN;
  prof.v(ind)=NaN;
  prof.w(ind)=NaN;
  prof.Vh(ind)=NaN;
  ind=find(abs(prof.u)>60 | abs(prof.v)>60 | abs(prof.w)>60);
  prof.beta(ind)=NaN;
  prof.turb(ind)=NaN;
  prof.vels(ind,:)=NaN;
  prof.theta(ind)=NaN;
  prof.u(ind)=NaN;
  prof.v(ind)=NaN;
  prof.w(ind)=NaN;
  prof.Vh(ind)=NaN;
  prof.start_time=lidar.start_time;
  
  ind=find(prof.turb>1);
  ts(j)=prof.start_time;
  Vh(j,:)=prof.Vh;
  Vh(j,ind)=NaN;
  theta(j,:)=prof.theta;
  theta(j,ind)=NaN;
  w(j,:)=prof.w;
  w(j,ind)=NaN;
  
  filesave=[datestr(prof.start_time,'yyyymmdd_HHMMSS'),'_profile','.mat'];
  ttdir=datestr(prof.start_time,'yyyymmdd');
  if ~exist(['D:/CCNY18/Analysis/Pro/',ttdir],'dir')
      mkdir(['D:/CCNY18/Analysis/Pro/',ttdir])
  end
  save(fullfile(['D:/CCNY18/Analysis/Pro/',ttdir],filesave),'prof','lidar')
  
  hs=panel3(prof);
  saveas(hs,fullfile(['D:/CCNY18/Analysis/Pro'],[datestr(prof.start_time,'yyyymmdd_HHMMSS'),'.jpg']))
  pause(2)
  %close(hs)
  clear prof lidar
  
end